/*
 * File:        sysinit.c
 *
 * Notes:
 *
 */

#include "MAC57D54H.h"
#include "sysinit.h"


extern void _start_T();

void disable_wdg_early()
{
	SWT_0.SR.R = 0xC520; //key
	SWT_0.SR.R = 0xD928; //key
	SWT_0.CR.R = 0xFF00010A;
	_start_T();
}

#pragma ghs section rodata=".bh"
const int boot_header[7] = {
	0x005A0002,        // RCHW
	0x00000000,        // Reserved
	0x00000000,        // Secure boot start address
	0x00000000,        // Secure boot image length (in bytes)
	(int)disable_wdg_early, // CM4 Entry Point
	0x00000000,        // Reserved
	0x00000000,        // Reserved
};

void sysinit (void)
{

  /***** 
  CLKCONFIG:
  CA5: 320MHz
  DDR: 320MHz
  BUS: 160MHz
  IPS: 80MHz
  IOP: 80MHz
  CM4: 160MHz
  ******/
  
	/* enable permissions for masters to access peripherals */
	*(uint32_t *) 0x40000000 = 0x77777777; /* AIPS 0 */
	*(uint32_t *) 0x40000004 = 0x77777777; /* AIPS 0 */
	*(uint32_t *) 0x40080000 = 0x77777777; /* AIPS 1 */
	*(uint32_t *) 0x40080004 = 0x77777777; /* AIPS 1 */

	/* Calculations Based on 40MHz input XTAL (as per 208QFP validaiton board) */

	/* Setup System Clock dividers: */
	/* SOME OF THESE VALUES ARE ACTUALLY THE DEFAULTS SO THE WRITES WOULD NOT BE NEEDED - KEEPING IN FOR BACKUP */
	MC_CGM.SC_DC0.R = 0x80010000; /* set DDR/SDR div to 2 */
	MC_CGM.SC_DC1.R = 0x80010000; /* set CA5 div to 2 */
	MC_CGM.SC_DC2.R = 0x80030000; /* set CM4/Platform div to 4 */
	//MC_CGM.SC_DC3.R = 0x80070000; /* set Peripherals div to 8 */
	MC_CGM.SC_DC3.R = 0x80070000; /* set Peripherals div to 8 */
	MC_CGM.SC_DC4.R = 0x80070000; /* set IOP div to 8 */
	MC_CGM.SC_DC5.R = 0x80010000; /* set 2xPlatform div to 2 */

	/* enable all modes, enable all peripherals */
	MC_ME.ME.R = 0x0000A5FF;
	MC_ME.RUN_PC[0].R = 0x000000FE;

	MC_ME.DRUN_MC.R = 0x00130030;
	MC_ME.MCTL.R = 0x30005AF0;
	MC_ME.MCTL.R = 0x3000A50F;
	while(MC_ME.GS.B.S_MTRANS == 1);      /* Wait for mode transition complete */

	MC_CGM.AC0_SC.B.SELCTL = 1; /* change PLL source to FXOSC */
	while(MC_CGM.AC0_SC.B.SELCTL == 0);/* ensure that change has occured - for test purposes only */    

	/* Configure PLL0 Dividers - 640MHz from 40Mhx XOSC */
	/* PLL input = FXOSC = 40MHz
	VCO range = 600-1280MHz
	PREDIV = 1 =? /1
	RFDPHI1= 2 => /8
	RFDPHI = 0 => /2
	MFD    = 32 => /32
	VCO frequency = PLL input / PREDIV x MFD = 40/1 * 16 = 1280 MHz
	PLL out = VCO / (RFDPHI*2) = 1280 / 2 = 640 MHz
	*/
	PLLDIG_0.PLLDV.R = 0x04001020;
	PLLDIG_0.PLLCAL3.R = 0x09C3C000;
	PLLDIG_0.PLLFD.B.SMDEN = 1;//sigma delta modulation disabled



	/* switch to PLL */
	PFLASH.PFCR1.B.RWSC = 4;/* enable required wait states on flash */
	// MC_ME.DRUN_MC.R = 0x001301F4;
	MC_ME.DRUN_MC.R = 0x00130130;
	MC_ME.MCTL.R = 0x30005AF0;
	MC_ME.MCTL.R = 0x3000A50F;
	while(MC_ME.GS.B.S_MTRANS == 1);      /* Wait for mode transition complete */
	while(PLLDIG_0.PLLSR.B.LOCK ==0);

	MC_ME.DRUN_MC.B.SYSCLK=4; 
	MC_ME.MCTL.R = 0x30005AF0;     	         /* Mode & Key */
	MC_ME.MCTL.R = 0x3000A50F;                /* Mode & Key inverted */
	while(MC_ME.GS.B.S_MTRANS == 1);		         /* Wait for mode entry to complete */
	while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);       /* Check DRUN mode has been entered */  
	while(PLLDIG_0.PLLSR.B.LOCK ==0);

	#if 0
	/* FOR DEBUG: Enable CLKOUT_0 and _1 */
	SIUL2.MSCR[116].R = 0x020000006; /* CLKOUT_0 = PH[4] = PIN 166 on 208LQFP */
	// SIUL2.MSCR[112].R = 0x020000006; /* CLKOUT_1 = PH[0] = PIN 162 on 208LQFP */
	MC_CGM.AC12_SC.B.SELCTL = 8; /* set CLKOUT_0 to SYSCLK */
	MC_CGM.AC12_DC0.R = 0x80090000; /* divide CLKOUT_0 by 10 */
	// MC_CGM.AC13_SC.B.SELCTL = 1; /* set CLKOUT_1 to FXOSC */
	// MC_CGM.AC13_DC0.R = 0x80000000; /* divide CLKOUT_1 by 1 */
	#endif
}

void disable_wdog()
{
	SWT_0.SR.R = 0xC520; //key
	SWT_0.SR.R = 0xD928; //key
	SWT_0.CR.R = 0xFF00010A;
}

void ecc_init()
{
	uint32_t* k;
	long long i, j[8];
	/* initialise TCML (32bit parity) */
	for (k=0x1e000000;k<0x1E007FFF; k++)
		*k = 0xFFFFFFFF; 
	/* initialise TCMU (32bit parity) */
	for (k=0x3e000000;k<0x3E007FFF; k++)
		*k = 0xFFFFFFFF; 
	/* initialise IOP (32bit ECC) */
	for (k=0x3e400000;k<0x3E407FFF; k++)
		*k = 0xFFFFFFFF; 
		
	/* use DMA to initialise SRAM ECC (64bit) */
	/* initialise array */
	for(i=0;i<8;i++)
		j[i] = 0xffffffff;
	
	/* 32-byte (4x 64-bit burst) */
	DMA_1.TCD[0].SADDR.B.SADDR            = (uint32_t)&j;                
	DMA_1.TCD[0].SOFF.B.SOFF                   = 0;                      //32byte source offset
	DMA_1.TCD[0].ATTR.B.SMOD                = 0;                      
	DMA_1.TCD[0].ATTR.B.SSIZE                  = 3;                      //0x5 => 32byte, 0x3=>64bit
	DMA_1.TCD[0].ATTR.B.DMOD                = 0;                                         
	DMA_1.TCD[0].ATTR.B.DSIZE                  = 3;                       //0x5 => 32byte, 0x3=>64bit
	DMA_1.TCD[0].NBYTES.MLNO.B.NBYTES           = 0x100000;                                                                    //1MB                                                                      
	DMA_1.TCD[0].SLAST.B.SLAST                = 0;                                                                                   
	DMA_1.TCD[0].DADDR.B.DADDR           = 0x3EF00000;  
	DMA_1.TCD[0].DOFF.B.DOFF                  = 8;//32;                                                                                 //32byte destination offset          
	DMA_1.TCD[0].CITER.ELINKNO.B.ELINK             = 0;                                                                                                                 
	DMA_1.TCD[0].CITER.ELINKNO.B.CITER             = 1;                                      
	DMA_1.TCD[0].DLASTSGA.B.DLASTSGA               = 0;
	DMA_1.TCD[0].BITER.ELINKNO.B.ELINK             = 0;                                                                                                  
	DMA_1.TCD[0].BITER.ELINKNO.B.BITER             = 1;                              
	DMA_1.TCD[0].CSR.R = 0;  
	DMA_1.SERQ.R = 0; /* set TCD0 enable */
	DMA_1.TCD[0].CSR.B.START           = 1; /* start TCD0 */
	//DMA_1.SSRT.R = 0; /* start TCD0 */  
	while(DMA_1.TCD[0].CSR.B.DONE !=1); /* wait until init is complete */
	
}
